<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'message', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   core_message
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['acceptandaddcontact'] = 'Accept and add to contacts';
$string['addcontact'] = 'Add contact';
$string['addcontactconfirm'] = 'Are you sure you want to add {$a} to your contacts?';
$string['addtoyourcontacts'] = 'Add to contacts';
$string['addtoyourcontactsandmessage'] = 'Add to contacts and message';
$string['addtofavourites'] = 'Star';
$string['ago'] = '{$a} ago';
$string['allusers'] = 'All messages from all users';
$string['backto'] = 'Back to {$a}';
$string['backupmessageshelp'] = 'If enabled, then instant messages will be included in SITE automated backups';
$string['blockcontact'] = 'Block contact';
$string['blockedusers'] = 'Blocked users';
$string['blockuser'] = 'Block user';
$string['blockuserconfirm'] = 'Are you sure you want to block {$a}?';
$string['blocknoncontacts'] = 'Prevent non-contacts from messaging me';
$string['canceledit'] = 'Cancel editing messages';
$string['contactableprivacy'] = 'Accept messages from:';
$string['contactableprivacy_onlycontacts'] = 'My contacts only';
$string['contactableprivacy_coursemember'] = 'My contacts and anyone in my courses';
$string['contactableprivacy_site'] = 'Anyone on the site';
$string['contactblocked'] = 'Contact blocked';
$string['contactrequests'] = 'Contact requests';
$string['contactrequestsent'] = 'Contact request sent';
$string['contacts'] = 'Contacts';
$string['decline'] = 'Decline';
$string['defaultmessageoutputs'] = 'Default message outputs';
$string['defaults'] = 'Defaults';
$string['deleteallconfirm'] = "Are you sure you would like to delete this entire conversation? This will not delete it for other conversation participants.";
$string['deleteallmessages'] = "Delete all messages";
$string['deleteconversation'] = "Delete conversation";
$string['deleteselectedmessages'] = 'Delete selected messages';
$string['deleteselectedmessagesconfirm'] = 'Are you sure you would like to delete the selected messages? This will not delete them for other conversation participants.';
$string['disableall'] = 'Disable notifications';
$string['disabled'] = 'Messaging is disabled on this site';
$string['disallowed'] = 'Disallowed';
$string['editmessages'] = 'Edit messages';
$string['emailtagline'] = 'This is a copy of a message sent to you at "{$a->sitename}". Go to {$a->url} to reply.';
$string['enabled'] = 'Enabled';
$string['errorcallingprocessor'] = 'Error calling defined output';
$string['errorconversationdoesnotexist'] = 'Conversation does not exist';
$string['errortranslatingdefault'] = 'Error translating default setting provided by plugin, using system defaults instead.';
$string['eventgroupmessagesent'] = 'Group message sent';
$string['eventnotificationviewed'] = 'Notification viewed';
$string['eventnotificationsent'] = 'Notification sent';
$string['eventmessagecontactadded'] = 'Message contact added';
$string['eventmessagecontactremoved'] = 'Message contact removed';
$string['eventmessagedeleted'] = 'Message deleted';
$string['eventmessageuserblocked'] = 'User blocked';
$string['eventmessageuserunblocked'] = 'User unblocked';
$string['eventmessageviewed'] = 'Message viewed';
$string['eventmessagesent'] = 'Message sent';
$string['forced'] = 'Locked';
$string['guestnoeditmessage'] = 'Guest user can not edit messaging options';
$string['guestnoeditmessageother'] = 'Guest user can not edit other user messaging options';
$string['groupinfo'] = 'Group info';
$string['groupconversations'] = 'Group';
$string['groupmessages'] = 'Group';
$string['hidemessagewindow'] = 'Hide message window';
$string['hidenotificationwindow'] = 'Hide notification window';
$string['individualconversations'] = 'Private';
$string['info'] = 'Info';
$string['isnotinyourcontacts'] = '{$a} is not in your contacts';
$string['loadmore'] = 'Load more';
$string['loggedin'] = 'Online';
$string['loggedin_help'] = 'Configure how you would like to receive notifications when you are logged into Moodle';
$string['loggedindescription'] = 'When you are logged into Moodle';
$string['loggedoff'] = 'Offline';
$string['loggedoff_help'] = 'Configure how you would like to receive notifications when you are not logged into Moodle';
$string['loggedoffdescription'] = 'When you are not logged into Moodle';
$string['managemessageoutputs'] = 'Manage message outputs';
$string['messageoutputs'] = 'Message outputs';
$string['messagepreferences'] = 'Message preferences';
$string['message'] = 'Message';
$string['messagecontactrequestsnotification'] = '{$a} wants to be added as a contact';
$string['messagecontactrequestsnotificationsubject'] = '{$a} wants to be added as a contact';
$string['messagedrawerviewcontact'] = 'User details for {$a}';
$string['messagedrawerviewcontacts'] = 'Message contacts';
$string['messagedrawerviewconversation'] = 'Conversation with {$a}';
$string['messagedrawerviewgroupinfo'] = 'Group details for {$a}';
$string['messagedrawerviewoverview'] = 'Messages overview';
$string['messagedrawerviewsearch'] = 'Messages search results for {$a}';
$string['messagedrawerviewsettings'] = 'Message settings';
$string['messagepreferences'] = 'Message preferences';
$string['messages'] = 'Messages';
$string['messagesselected:'] = 'Messages selected:';
$string['messagingdatahasnotbeenmigrated'] = 'Your messages are temporarily unavailable due to upgrades in the messaging infrastructure. Please wait for them to be migrated.';
$string['newonlymsg'] = 'Show only new';
$string['newmessage'] = 'New message';
$string['newmessagesearch'] = 'Select or search for a contact to send a new message.';
$string['nofavourites'] = 'No starred conversations';
$string['noframesjs'] = 'Use more accessible interface';
$string['nocontactrequests'] = 'No contact requests';
$string['nocontacts'] = 'No contacts';
$string['nocontactsgetstarted'] = 'No contacts';
$string['nogroupconversations'] = 'No group conversations';
$string['nogroupmessages'] = 'No group conversations';
$string['nomessages'] = 'No messages';
$string['noindividualconversations'] = 'No private conversations';
$string['nomessagesfound'] = 'No messages were found';
$string['noreply'] = 'Do not reply to this message';
$string['noncontacts'] = 'Non-contacts';
$string['nonotifications'] = 'You have no notifications';
$string['noparticipants'] = 'No participants';
$string['notificationdatahasnotbeenmigrated'] = 'Your notifications are temporarily unavailable due to upgrades in the notification infrastructure. Please wait for them to be migrated.';
$string['notificationwindow'] = 'Notification window';
$string['notificationpreferences'] = 'Notification preferences';
$string['notificationimage'] = 'Notification image';
$string['notifications'] = 'Notifications';
$string['notincontactsheading'] = '{$a} is not in your contacts';
$string['notincontacts'] = 'You need to add {$a} to your contacts to be able to send them messages.';
$string['numparticipants'] = '{$a} participants';
$string['off'] = 'Off';
$string['offline'] = 'Offline';
$string['on'] = 'On';
$string['online'] = 'Online';
$string['otherparticipants'] = 'Other participants';
$string['outputdisabled'] = 'Output disabled';
$string['outputdoesnotexist'] = 'Message output does not exist';
$string['outputenabled'] = 'Output enabled';
$string['outputnotavailable'] = 'Not available';
$string['outputnotconfigured'] = 'Not configured';
$string['participants'] = 'Participants';
$string['permitted'] = 'Permitted';
$string['privacy'] = 'Privacy';
$string['privacy_desc'] = 'You can restrict who can message you';
$string['privacy:metadata:core_favourites'] = 'The conversations starred by the user';
$string['privacy:metadata:messages'] = 'Messages';
$string['privacy:metadata:messages:conversationid'] = 'The ID of the conversation';
$string['privacy:metadata:messages:fullmessage'] = 'The full message';
$string['privacy:metadata:messages:fullmessageformat'] = 'The format of the full message';
$string['privacy:metadata:messages:fullmessagehtml'] = 'The HTML format of the full message';
$string['privacy:metadata:messages:useridfrom'] = 'The ID of the user who sent the message';
$string['privacy:metadata:messages:smallmessage'] = 'A small version of the message';
$string['privacy:metadata:messages:subject'] = 'The subject of the message';
$string['privacy:metadata:messages:timecreated'] = 'The time when the message was created';
$string['privacy:metadata:message_contacts'] = 'The list of contacts';
$string['privacy:metadata:message_contacts:contactid'] = 'The ID of the user who is a contact';
$string['privacy:metadata:message_contacts:timecreated'] = 'The time when the contact was created';
$string['privacy:metadata:message_contacts:userid'] = 'The ID of the user whose contact list we are viewing';
$string['privacy:metadata:message_contact_requests'] = 'The list of contact requests';
$string['privacy:metadata:message_contact_requests:requesteduserid'] = 'The ID of the user who received the contact request';
$string['privacy:metadata:message_contact_requests:timecreated'] = 'The time when the contact request was created';
$string['privacy:metadata:message_contact_requests:userid'] = 'The ID of the user who sent the contact request';
$string['privacy:metadata:message_conversation_members'] = 'The list of users in a conversation';
$string['privacy:metadata:message_conversation_members:conversationid'] = 'The ID of the conversation';
$string['privacy:metadata:message_conversation_members:timecreated'] = 'The time when the member was created';
$string['privacy:metadata:message_conversation_members:userid'] = 'The ID of the user in a conversation';
$string['privacy:metadata:message_user_actions'] = 'The list of message user actions';
$string['privacy:metadata:message_user_actions:action'] = 'The action that was performed';
$string['privacy:metadata:message_user_actions:messageid'] = 'The ID of the message this action belongs to';
$string['privacy:metadata:message_user_actions:timecreated'] = 'The time when the action was created';
$string['privacy:metadata:message_user_actions:userid'] = 'The ID of the user who performed this action';
$string['privacy:metadata:message_users_blocked'] = 'The list of blocked users';
$string['privacy:metadata:message_users_blocked:blockeduserid'] = 'The ID of the user who was blocked';
$string['privacy:metadata:message_users_blocked:timecreated'] = 'The time when the blocked action was created';
$string['privacy:metadata:message_users_blocked:userid'] = 'The ID of the user who performed the blocked action';
$string['privacy:metadata:notifications'] = 'Notifications';
$string['privacy:metadata:notifications:component'] = 'The component responsible for sending the notification';
$string['privacy:metadata:notifications:contexturl'] = 'The URL related to this notification';
$string['privacy:metadata:notifications:contexturlname'] = 'The name of the context';
$string['privacy:metadata:notifications:eventtype'] = 'The event type';
$string['privacy:metadata:notifications:fullmessage'] = 'The full notification';
$string['privacy:metadata:notifications:fullmessageformat'] = 'The notification format';
$string['privacy:metadata:notifications:fullmessagehtml'] = 'The HTML of the notification';
$string['privacy:metadata:notifications:smallmessage'] = 'The small message of the notification';
$string['privacy:metadata:notifications:subject'] = 'The subject of the notification';
$string['privacy:metadata:notifications:timeread'] = 'The time when the notification was read';
$string['privacy:metadata:notifications:timecreated'] = 'The time when the notification was created';
$string['privacy:metadata:notifications:useridfrom'] = 'The ID of the user who sent the notification';
$string['privacy:metadata:notifications:useridto'] = 'The ID of the user who received the notification';
$string['privacy:metadata:preference:core_message_settings'] = 'Settings related to messaging';
$string['privacy:request:preference:set'] = 'The value of the setting \'{$a->name}\' was \'{$a->value}\'';
$string['privacy:export:conversationprefix'] = 'Conversation: ';
$string['processorsettings'] = 'Processor settings';
$string['removecontact'] = 'Remove contact';
$string['removecontactconfirm'] = 'Are you sure you want to remove {$a} from your contacts?';
$string['removecoursefilter'] = 'Remove filter for course {$a}';
$string['removefromyourcontacts'] = 'Remove from contacts';
$string['removefromfavourites'] = 'Unstar';
$string['requirecontacttomessage'] = 'You need to request {$a} to add you as a contact to be able to message them.';
$string['requiresconfiguration'] = 'Requires configuration';
$string['searchforuser'] = 'Search for a user';
$string['searchforuserorcourse'] = 'Search for a user or course';
$string['searchmessages'] = 'Search messages';
$string['searchnocontactsfound'] = 'No contacts found';
$string['searchnomessagesfound'] = 'No messages found';
$string['searchnononcontactsfound'] = 'No non contacts found';
$string['searchcombined'] = 'Search people and messages';
$string['seeall'] = 'See all';
$string['selectmessagestodelete'] = 'Select messages to delete';
$string['selectnotificationtoview'] = 'Select from the list of notifications on the side to view more details';
$string['send'] = 'Send';
$string['sender'] = '{$a}:';
$string['sendingvia'] = 'Sending "{$a->provider}" via "{$a->processor}"';
$string['sendingviawhen'] = 'Sending "{$a->provider}" via "{$a->processor}" when {$a->state}';
$string['sendcontactrequest'] = 'Send contact request';
$string['sendmessage'] = 'Send message';
$string['sendbulkmessage'] = 'Send message to {$a} people';
$string['sendbulkmessagesingle'] = 'Send message to 1 person';
$string['sendbulkmessagesent'] = 'Message sent to {$a} people';
$string['sendbulkmessagesentsingle'] = 'Message sent to 1 person';
$string['sendmessageto'] = 'Send message to {$a}';
$string['sendmessagetopopup'] = 'Send message to {$a} - new window';
$string['settings'] = 'Settings';
$string['showmessagewindownonew'] = 'Show message window with no new messages';
$string['showmessagewindowwithcount'] = 'Show message window with {$a} new messages';
$string['shownotificationwindownonew'] = 'Show notification window with no new notifications';
$string['shownotificationwindowwithcount'] = 'Show notification window with {$a} new notifications';
$string['togglenotificationmenu'] = 'Toggle notifications menu';
$string['togglemessagemenu'] = 'Toggle messaging drawer';
$string['touserdoesntexist'] = 'You can not send a message to a user id ({$a}) that doesn\'t exist';
$string['unabletomessage'] = 'You are unable to message this user';
$string['unblock'] = 'Unblock';
$string['unblockcontact'] = 'Unblock contact';
$string['unblockuser'] = 'Unblock user';
$string['unblockuserconfirm'] = 'Are you sure you want to unblock {$a}?';
$string['unknownuser'] = 'Unknown user';
$string['unreadnotification'] = 'Unread notification: {$a}';
$string['unreadnewgroupconversationmessage'] = 'New message from {$a->name} in {$a->conversationname}';
$string['unreadnewmessage'] = 'New message from {$a}';
$string['useentertosend'] = 'Use enter to send';
$string['usercantbemessaged'] = 'You can\'t message {$a} due to their message preferences. Try adding them as a contact.';
$string['userisblockingyou'] = 'This user has blocked you from sending messages to them';
$string['userisblockingyounoncontact'] = '{$a} only accepts messages from their contacts.';
$string['userwouldliketocontactyou'] = '{$a} would like to contact you';
$string['viewfullnotification'] = 'View full notification';
$string['viewinganotherusersmessagearea'] = 'You are viewing another user\'s message area.';
$string['viewmessageswith'] = 'View messages with {$a}';
$string['viewnotificationresource'] = 'Go to: {$a}';
$string['viewunreadmessageswith'] = 'View unread messages with {$a}';
$string['writeamessage'] = 'Write a message...';
$string['wouldliketocontactyou'] = 'Would like to contact you';
$string['you'] = 'You:';
$string['youhaveblockeduser'] = 'You have blocked this user in the past';
$string['yourcontactrequestpending'] = 'Your contact request is pending with {$a}';

// Deprecated since Moodle 3.6.
$string['eventmessagecontactblocked'] = 'Message contact blocked';
$string['eventmessagecontactunblocked'] = 'Message contact unblocked';
$string['messagingdisabled'] = 'Messaging is disabled on this site, emails will be sent instead';
$string['userisblockingyou'] = 'This user has blocked you from sending messages to them.';
$string['userisblockingyounoncontact'] = '{$a} only accepts messages from their contacts.';
